import Image from "next/image";
import {
  IoIosArrowDropleftCircle,
  IoIosArrowDroprightCircle,
} from "react-icons/io";
import { Carousel } from "./Carousel";
import menuEntrada from "../../public/images/menu/menu-entradas.webp";
import menuHamburguesas1 from "../../public/images/menu/menu-hamburguesas-1.webp";
import menuHamburguesas2 from "../../public/images/menu/menu-hamburguesas-2.webp";
import menuPapas from "../../public/images/menu/menu-papas.webp";
import menuPostres from "../../public/images/menu/menu-postres.webp";

const images = [
  menuEntrada,
  menuHamburguesas1,
  menuHamburguesas2,
  menuPapas,
  menuPostres,
];

export const Seccion2 = () => {
  return (
    <>
      <div
        className="flex grid-rows-2 gap-10 justify-center items-center"
        id="menu"
      >
        <div>
          <span className="flex justify-center text-xl text-text-color font-semibold">
            DESCUBRE DESTINOS GLOBALES EN CADA BOCADO
          </span>
          <h1 className="flex font-bold text-8xl text-navbar-color mt-5 mb-5 justify-center">
            MENÚ
          </h1>
          <span className="flex justify-center text-lg text-text-color font-light">
            Explora nuestro mapa de sabores
          </span>
        </div>
      </div>
      <div className="w-3/4 m-auto p-4">
        <Carousel images={images} />
      </div>
    </>
  );
};
