import Link from "next/link";
import { MdKeyboardDoubleArrowDown } from "react-icons/md";

export const BannerStart = () => {
  return (
    <div className="w-screen flex items-center justify-center flex-col">
      <video
        className="h-full w-full"
        autoPlay
        playsInline
        loop
        muted
        preload="auto"
      >
        <source src="/banners/bannerPrincipal.webm" type="video/webm" />
      </video>
      <Link
        href={"#bienvenido"}
        className="flex flex-col justify-centers items-center mt-5"
      >
        <span className="text-xl font-semibold text-navbar-color">VER MÁS</span>
        <MdKeyboardDoubleArrowDown className="text-3xl text-navbar-color" />
      </Link>
    </div>
  );
};
