import Link from "next/link";
import Image from "next/image";
import instagramIcon from "../../public/icons/instagram.svg";
import tiktokIcon from "../../public/icons/tiktok.svg";
import logo from "../../public/logos/burgerPostOffice3.svg";

const navItems = [
  {
    id: 1,
    path: "#menu",
    text: "Menú",
  },
  {
    id: 2,
    path: "#ubicacion",
    text: "Ubicación",
  },
  {
    id: 3,
    path: "/eventos",
    text: "Eventos",
  },
];

const socialIcons = [
  {
    id: 1,
    src: instagramIcon,
    href: "https://www.instagram.com/burgerpostoffice?igshid=OGQ5ZDc2ODk2ZA==",
  },
  {
    id: 2,
    src: tiktokIcon,
    href: "https://www.tiktok.com/es/",
  },
];

export const Navbar = () => {
  return (
    <nav className="flex flex-row items-center justify-between bg-navbar-color w-screen">
      {/* Aqui falta el logo */}
      <div className="ml-20">
        <Link href="/">
          <Image src={logo} alt="Logo" width={250} height={"auto"} priority />
        </Link>
      </div>
      <div className="flex items-center">
        {/* Rutas dinamicas para los endpoint */}
        <div className="flex-row mr-48">
          {navItems.map((navItem) => {
            return (
              <Link
                key={navItem.id}
                className="mr-8 text-lg text-zinc-300 hover:text-zinc-50 font-normal"
                href={navItem.path}
              >
                {navItem.text}
              </Link>
            );
          })}
        </div>
        {/* Rutas dinamicas para los iconos */}
        <div className="flex flex-row mr-40">
          {socialIcons.map((socialIcon) => {
            return (
              <Link href={socialIcon.href} key={socialIcon.id}>
                <Image
                  src={socialIcon.src}
                  alt="Instagram Icon"
                  className="w-5 h-7 mr-8 hover:text-icons-color"
                />
              </Link>
            );
          })}
        </div>
      </div>
    </nav>
  );
};
