import Link from "next/link";
// import Image from "next/image";
// import instagramIcon from "../../public/icons/instagram.svg";
// import tiktokIcon from "../../public/icons/tiktok.svg";
// import phoneIcon from "../../public/icons/phone.svg";
import { FaTiktok } from "react-icons/fa";
import { AiFillInstagram } from "react-icons/ai";

const socialIcons = [
  {
    id: 1,
    // src: instagramIcon,
    href: "https://www.instagram.com/burgerpostoffice?igshid=OGQ5ZDc2ODk2ZA==",
    alt: "Instagram Icon",
  },
  {
    id: 2,
    // src: tiktokIcon,
    href: "https://www.tiktok.com/es/",
    alt: "Tik Tok Icon",
  },
  // {
  //   id: 3,
  //   src: phoneIcon,
  //   href: "https://web.whatsapp.com/",
  //   alt: "Phone Icon",
  // },
];

export const Seccion3 = () => {
  return (
    <div
      className="flex grid-cols-2 gap-40 mt-14 mb-20 justify-center items-center"
      id="ubicacion"
    >
      <div>
        {/* <Image src={mapa} width={700} height={700} alt="Map Image" /> */}
        <iframe
          src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d3941.115415853448!2d-79.5367202758789!3d8.961511611938477!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x8faca8c83c0b273d%3A0x17596a3f1f8b31f8!2sThe%20Sands%20Apartments%20%26%20Mall!5e0!3m2!1ses!2sve!4v1702657387211!5m2!1ses!2sve"
          width="600"
          height="450"
          style={{ border: "0", marginRight: "auto" }}
          allowFullScreen=""
          loading="lazy"
          referrerPolicy="no-referrer-when-downgrade"
        ></iframe>
      </div>
      <div className="w-4/12">
        <h2 className="text-xl text-text-color font-semibold">
          TE ESPERAMOS PARA VIVIR LA EXPERIENCIA
        </h2>
        <h1 className="text-7xl text-navbar-color font-semibold mt-8 mb-4">
          VISÍTANOS
        </h1>
        <div className="flex flex-col mt-5 mb-10">
          <p className="text-icons-color text-left text-xl font-light">
            {`Avenida Balboa, Ciudad de Panamá, Panamá (PH The Sands Apartments & Mall)`}
          </p>
        </div>
        <div className="flex items-center">
          {/* Rutas dinamicas para los iconos */}
          <div className="flex flex-row mr-32">
            {socialIcons.map((socialIcon) => {
              return (
                <Link href={socialIcon.href} key={socialIcon.id}>
                  {/* {socialIcon.src === phoneIcon ? (
                    <div className="flex flex-row items-center">
                      <Image
                        src={socialIcon.src}
                        alt={socialIcon.alt}
                        className="w-7 h-9 mr-6 bg-icons-color hover:text-icons-color"
                      />
                      <span className="text-text-color text-xl font-light">
                        00000000
                      </span>
                    </div>
                  ) : ( */}
                  {socialIcon.alt === "Tik Tok Icon" ? (
                    <FaTiktok className="w-6 h-9 mr-8 text-text-color hover:text-icons-color" />
                  ) : (
                    <AiFillInstagram className="w-9 h-9 mr-8 text-text-color hover:text-icons-color" />
                  )}
                  {/* <Image
                    src={socialIcon.src}
                    alt={socialIcon.alt}
                    className="w-7 h-9 mr-8 bg-icons-color hover:text-icons-color"
                  /> */}
                  {/* )} */}
                </Link>
              );
            })}
          </div>
        </div>
      </div>
    </div>
  );
};
