import Image from "next/image";
import Link from "next/link";
import postales from "../../public/images/postales.webp";

export const Seccion1 = () => {
  return (
    <>
      <div
        className="flex grid-cols-2 gap-20 mt-14 mb-5 justify-center items-center"
        id="bienvenido"
      >
        <div>
          <Image
            src={postales}
            width={"auto"}
            height={"auto"}
            alt="Postcard Image"
          />
        </div>
        <div className="w-1/3">
          <h2 className="text-xl text-text-color font-semibold">
            SABOREA EL MUNDO EN UN MORDISCO
          </h2>
          <h1 className="text-7xl text-navbar-color font-semibold mt-4 mb-4">
            BIENVENIDO!
          </h1>
          <div className="flex flex-col mt-10 mb-10">
            <p className="text-icons-color text-left text-xl font-light">
              ¡Bienvenidos a Burger Post Office, el lugar en donde cada plato se
              convierte en una postal gastronómica de tu lugra favorito del
              mundo! Desde nuestra peculiar oficiona de correo hemos
              desarrollado un concepto único que te hará conectar al instante
              con la multiculturidad de los diversos sabores internacionales.
            </p>
          </div>
          <Link href={"#menu"}>
            <button className="bg-white border-navbar-color text-navbar-color hover:bg-navbar-color hover:text-white border-2 font-semibold pt-2 pb-2 pr-10 pl-10 rounded-md">
              VER MENÚ
            </button>
          </Link>
        </div>
      </div>
      {/* Banner Sección1 */}
      <div className="w-screen flex items-end justify-center  mb-20 relative">
        <video
          className="h-full w-full"
          autoPlay
          playsInline
          loop
          muted
          preload="auto"
        >
          <source src="/banners/bannerSección1.webm" type="video/webm" />
        </video>
        <button className="bg-transparent border-white text-white hover:bg-navbar-color hover:text-white hover:border-navbar-color border-2 font-bold pt-2 pb-2 pr-10 pl-10 mb-5 rounded-md absolute">
          VISÍTANOS
        </button>
      </div>
    </>
  );
};
