"use client";

import { useState } from "react";
import React from "react";
import {
  IoIosArrowDropleftCircle,
  IoIosArrowDroprightCircle,
} from "react-icons/io";
import Image from "next/image";

export const Carousel = ({ images }) => {
  const [currentIndex, setCurrentIndex] = useState(0);

  const nextSlide = () => {
    const newIndex = (currentIndex + 1) % images.length;
    setCurrentIndex(newIndex);
  };

  const prevSlide = () => {
    const newIndex = (currentIndex - 1 + images.length) % images.length;
    setCurrentIndex(newIndex);
  };

  return (
    <div className="flex items-center justify-center mb-4">
      <button
        className="text-5xl text-icons-color opacity-25 hover:text-navbar-color hover:opacity-100"
        onClick={prevSlide}
      >
        <IoIosArrowDropleftCircle />
      </button>
      <Image
        className="max-w-full h-auto"
        src={images[currentIndex]}
        alt="Carousel Slide"
      />
      <button
        className="text-5xl text-icons-color opacity-25 hover:text-navbar-color hover:opacity-100"
        onClick={nextSlide}
      >
        <IoIosArrowDroprightCircle />
      </button>
    </div>
  );
};
