import Link from "next/link";
import Image from "next/image";
import instagramIcon from "../../public/icons/instagram.svg";
import tiktokIcon from "../../public/icons/tiktok.svg";
import phoneIcon from "../../public/icons/phone.svg";
import logo from "../../public/logos/burgerPostOffice2.png";

const navItems = [
  {
    id: 1,
    path: "#menu",
    text: "MENÚ",
  },
  {
    id: 2,
    path: "#ubicacion",
    text: "UBICACIÓN",
  },
  {
    id: 3,
    path: "/eventos",
    text: "EVENTOS",
  },
];

const socialIcons = [
  {
    id: 1,
    src: instagramIcon,
    href: "https://www.instagram.com/burgerpostoffice?igshid=OGQ5ZDc2ODk2ZA==",
    alt: "Instagram Icon",
  },
  {
    id: 2,
    src: tiktokIcon,
    href: "https://www.tiktok.com/es/",
    alt: "Tik Tok Icon",
  },
  // {
  //   id: 3,
  //   src: phoneIcon,
  //   href: "https://web.whatsapp.com/",
  //   alt: "Phone Icon",
  // },
];

export const Footer = () => {
  return (
    <footer className="flex flex-row items-center justify-between bg-icons-color w-screen inset-x-0 bottom-0">
      <div className="flex items center ml-14">
        <Link href="/">
          <Image src={logo} alt="Logo 2" width={300} height={"auto"} />
        </Link>
      </div>
      <div className="flex items-center">
        {/* Rutas dinamicas para los endpoint */}
        <div className="flex-row mr-96">
          {navItems.map((navItem) => {
            return (
              <Link
                key={navItem.id}
                className="ml-8 text-lg text-zinc-300 hover:text-zinc-50 font-light"
                href={navItem.path}
              >
                {navItem.text}
              </Link>
            );
          })}
        </div>
        {/* Rutas dinamicas para los iconos */}
        <div className="flex flex-row mr-60">
          {socialIcons.map((socialIcon) => {
            return (
              <Link href={socialIcon.href} key={socialIcon.id}>
                {/* {socialIcon.src === phoneIcon ? (
                  <div className="flex flex-row items-center">
                    <Image
                      src={socialIcon.src}
                      alt={socialIcon.alt}
                      className="w-7 h-9 mr-6 hover:text-icons-color"
                    />
                    <span className="text-zinc-300 text-xl">00000000</span>
                  </div>
                ) : ( */}
                <Image
                  src={socialIcon.src}
                  alt={socialIcon.alt}
                  className="w-7 h-9 mr-8 hover:text-icons-color"
                />
                {/* )} */}
              </Link>
            );
          })}
        </div>
      </div>
    </footer>
  );
};
